# Dehancer Production License Server

The Dehancer Production License Server (DPLS) provides license activation service for Dehancer Plugins over a local network, including air-gapped production environments.

It's standalone server binary for common *nix flavors.

# System requirements

Hardware: none. DPLS is immeasurably tiny, so a VM with 512MB ram would be sufficient.

DPLS works on:

* Linux aarch64 or Intel;
* Darwin (aka macOS) on Apple Silicon or Intel.

Recent Debian on Intel or ARM is recommended. The Linux binary is not statically built but it's not linking to particularly rare libraries either.

# Installation

## Download and extract the software

Grab the `dpls-<FLAVOR>-x.x.tar.xz` archive and extract it to a location (we suggest `/srv/dpls`).

Bear in mind that root privileges are not required for DPLS to run. Ensure the target directory is owned by the user running `dpls`.

## Specify data directory

`dpls` requires a `--datadir` argument pointing to a directory where it will store its data. We suggest using `/srv/dpls/data`. The directory is created automatically if it does not exist.

## Choose port and host

`dpls` is listening on a port that should be accessible within the local network. Dehancer Plugins connect to this port to activate instances. By default we use port `9989` and listen on `0.0.0.0` but that could be changed with `--port` and `--host` arguments respectively.

Note: make sure that `iptables`/`ufw` allow connections to that port.

## Start the server

Example startup command:

```bash
/srv/dpls/dpls --datadir /srv/dpls/data --port 8080 --host 192.168.0.1
```

Note: failed to run on macOS? As it is customary, don't forget to `xattr -cr /srv/dpls/dpls`.

## systemd

Example systemd unit file. Since `dpls` does not run as root, you should specify which user to run as.

```systemd
[Unit]
Description=Dehancer Production License Server

[Service]
ExecStart=/srv/dpls/dpls --datadir /srv/dpls/data
User=bob

[Install]
WantedBy=multi-user.target
```

# Initial configuration

Open the configured host/port in a web browser (eg: `http://<host>:9989`). You will see a setup screen where you create an admin username/password and enter your Production License key.

Configuration ends here.

# Update

Replace the binary with a new one and restart.

# Backup

Add the data directory (`--datadir`) to your backups.

Note: none of the data stored by DPLS is mission critical. If the directory is lost, restart and reconfigure the server with your Production License key. Workstations may need to reauthorize.

# Using Dehancer Plugins with DPLS

Download the latest release of the desired plugin from [dehancer.com](https://www.dehancer.com) and install as per installation manual.

To activate the plugin with the DPLS you will need to select the "Production License" tab and simply paste the URL of the DPLS in the local network.

Proceed to download profiles as usual.

Note: In air-gapped networks, film profiles cannot be downloaded from the public internet. After activation, all Dehancer Plugins will automatically fetch profiles from DPLS. Do not attempt to download profiles before activation.
